﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucReportPopulation.ascx.cs" Inherits="ucReportPopulation" %>
<ext:Window ID="wndLoadPopulation" 
    Title="Load Population" Hidden="true"
    Layout="AnchorLayout" Height="370" Width="390" 
     IDMode="Static" Padding="5" runat="server" 
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
<Items>    

    <ext:Panel Border="false" ID="pnlReportDateRange" 
                Layout="ColumnLayout" runat="server">
    <Items>
        <ext:Label Text="Date Range:" Padding="2" runat="server" width="90"></ext:Label>
         
        <ext:DateField ID="dfFromDate" 
            runat="server"
            AllowBlank="false"
            AutoDataBind="true"
            Width="100"
            Padding="5">
        </ext:DateField>

        <ext:Label Text="To" runat="server" Padding="3"></ext:Label>
        <ext:DateField ID="dfToDate"
            runat="server"
            AllowBlank="false"
            AutoDataBind="true"
            Width="100"
            Padding="5">
        </ext:DateField>

    </Items>
    </ext:Panel>

    <ext:Panel Border="false" Layout="FormLayout" runat="server">
    <Items>

         <ext:ComboBox ID="cboReportClinicalSetting" runat="server" 
             Editable="false" Width="300"
             FieldLabel="Clinical Setting" Padding="2" LabelWidth="90">
            <Items>
                <ext:ListItem Text="Inpatient" Value="2" Mode="Raw" />
                <ext:ListItem Text="Outpatient" Value="1" Mode="Raw" />
            </Items>
        </ext:ComboBox>

        <ext:ComboBox 
            runat="server" 
            ID="cboReportRegion" 
            ValueField="REGION_ID" 
            Editable="false" Width="300" FieldLabel="Region" Padding="2" LabelWidth="90"
            IDMode="Static" 
            DisplayField="REGION_NAME">
            <Store>
                <ext:Store ID="storReportRegion" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model runat="Server" IDProperty="REGION_ID">
                            <Fields>
                                <ext:ModelField Name="REGION_ID" />
                                <ext:ModelField Name="REGION_NAME" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
            <Listeners>
                <Change Handler="App.direct.REPORTSPOP.LoadSites(this.getValue());" />
            </Listeners>
        </ext:ComboBox>

        <ext:ComboBox runat="server" ID="cboReportSite"  
            ValueField="SITE_ID" Editable="false" Width="300" FieldLabel="Site" Padding="2" LabelWidth="90" 
             IDMode="Static" 
            DisplayField="SITE_NAME">
            <Store>
            <ext:Store ID="storReportSite" AutoLoad="true" runat="server">
                <Model>
                    <ext:Model runat="Server" IDProperty="SITE_ID">
                        <Fields>
                            <ext:ModelField Name="SITE_ID" />
                            <ext:ModelField Name="SITE_NAME" />
                        </Fields>
                    </ext:Model>
                </Model>
                <Reader>
                    <ext:JsonReader RootProperty="Tables[0].Rows">
                    </ext:JsonReader>
                </Reader>
            </ext:Store>
            </Store>
            <Listeners>
                <Change Handler="App.direct.REPORTSPOP.LoadPopuCPA(this.getValue());" />
            </Listeners>
        </ext:ComboBox>

        <ext:ComboBox
            ID="cboReportCPA"
            runat="server"
            Editable="false"
            ValueField="CPA_ID"
            DisplayField="CPA_TITLE"
             Width="300"
            FieldLabel="Clinical Program"
            LabelWidth="90"
            Padding="2">
            <Store>
                <ext:Store ID="storReportCPA" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model runat="Server" IDProperty="CPA_ID">
                            <Fields>
                                <ext:ModelField Name="CPA_ID" />
                                <ext:ModelField Name="CPA_TITLE" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>


         <ext:ComboBox
            ID="cboReportImpairment"
            runat="server"
            Editable="false"
            ValueField="RID"
            DisplayField="RESPONSE"
             Width="300"
            FieldLabel="Primary Impairment"
            LabelWidth="90"
            Padding="2">
            <Store>
                <ext:Store ID="storImpairment" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model runat="Server" IDProperty="RID">
                            <Fields>
                                <ext:ModelField Name="RID" />
                                <ext:ModelField Name="RESPONSE" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>

        <ext:ComboBox
            ID="cboReportInjury"
            runat="server"
            Editable="false"
            ValueField="RID"
            DisplayField="RESPONSE"
             Width="300"
            FieldLabel="Mechanism of Injury"
            LabelWidth="90"
            Padding="2">
            <Store>
                <ext:Store ID="storInjury" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model runat="Server" IDProperty="RID">
                            <Fields>
                                <ext:ModelField Name="RID" />
                                <ext:ModelField Name="RESPONSE" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>

        <ext:ComboBox
            ID="cboReportGender"
            runat="server"
            Editable="false"
            ValueField="COLLECTION_ITEM_ID"
            DisplayField="ITEM"
             Width="300"
            FieldLabel="Gender"
            LabelWidth="90"
            Padding="2">
            <Store>
                <ext:Store ID="storGender" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model runat="Server" IDProperty="COLLECTION_ITEM_ID">
                            <Fields>
                                <ext:ModelField Name="COLLECTION_ITEM_ID" />
                                <ext:ModelField Name="ITEM" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>

        <ext:ComboBox
            ID="cboReportMilStatus"
            runat="server"
            Editable="false"
            ValueField="COLLECTION_ITEM_ID"
            DisplayField="ITEM"
             Width="300"
            FieldLabel="Duty Status"
            LabelWidth="90"
            Padding="2">
            <Store>
                <ext:Store ID="storMilStatus" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model runat="Server" IDProperty="COLLECTION_ITEM_ID">
                            <Fields>
                                <ext:ModelField Name="COLLECTION_ITEM_ID" />
                                <ext:ModelField Name="ITEM" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>

    </Items>
    </ext:Panel>

</Items>
<BottomBar>
<ext:Toolbar runat="server">
<Items>
    <ext:Button ID="btnOK" runat="server" Text="OK" Icon="Disk" Handler="App.direct.REPORTSPOP.OnOK();" />
    <ext:Button ID="btnCancel" runat="server" Text="Cancel" Icon="Cancel" Handler="App.wndLoadPopulation.hide();" />
</Items>
</ext:Toolbar>
</BottomBar>
</ext:Window>
